#include <stdio.h>
#include "AD18F08.h"
#include "periph.h"
static volatile unsigned char	TESTCON                 @0xf5e;
static volatile bit	 TEST_EN                     @((unsigned)&TESTCON*8)+7;
void GPIO_Init(void)
{
	TRISA = 0X00;   //PA输出模式
	TRISB = 0X00;   //PB输出模式

	PORTA = 0X00;	//PORTA输出0
	PORTB = 0X00;	//PORTB输出0

	PAPD = 0XFF;    //关闭PA下拉
	PAPU = 0XFF;    //关闭PA上拉
	PBPD = 0XFF;    //关闭PB下拉
	PBPU = 0XFF;    //关闭PB上拉

	PAOD = 0X00;    //关PA开漏输出
	PBOD = 0X00;    //关PB开漏输出

	ANASEL0 = 0X00; //关PA模拟量通道
	ANASEL1 = 0X00; //关PB模拟量通道
}

void Timer1_Timer(void)
{
	TMR1H  = 0X00;
	TMR1L  = 0X00;
	T1CON0 = 0X25;  //
	T1CON1 = 0X00;

	TMR1IF = 0;      //清中断标志
	TMR1IP = 1;		 //高优先级中断
	TMR1IE = 1;      //开TMR1中断

}

void Timer2_Timer(void)
{
	PR2H = 0XFF;
	PR2L = 0XFF;
	TMR2H  = 0X00;
	TMR2L  = 0X00;
	T2CON = 0X07;  //时钟预分频为16分频     使能T2

	TMR2IF = 0;      //清中断标志
	TMR2IP = 1;		 //高优先级中断
	TMR2IE = 0;      //开TMR2中断
}


void CCP_init(void)
{
    TRISA4 = 1;PA4PD = 1;PA4PU = 1;PA4OD = 0;PA4AEN = 0;

	CCPR1H = 0X00;
	CCPR1L = 0X00;
	CCPR1LH = 0X80;         //选择TMR2计数值
	CCPCON = 0X09;          //PA4作为捕获信号引脚，捕捉模式，在每个上升沿发生，捕捉值存入 CCPR1寄存器，并产生中断标志 CCPIF
	printf("\r\n/*** [DEBUG] ***/\r\n");
	printf("CCPCON = 0X%02X !\r\n",CCPCON);
    printf("CCPR1LH = 0x%02X  \r\n",CCPR1LH);
	printf("/***************/\r\n\r\n");
	CCPIF = 0;      //清中断标志
	CCPIP = 1;		//高优先级中断
	CCPIE = 1;      //开CCP中断
}
